﻿# PowerShell-скрипт для регистрации comcntr.dll последней версии 1С с логированием
# Запускать от имени администратора!

# Папки, где может быть установлена 1С
$basePaths = @(
    "C:\Program Files (x86)\1cv8",
    "C:\Program Files\1cv8"
)

# Путь к лог-файлу рядом с .ps1
$logFile = Join-Path (Split-Path -Parent $MyInvocation.MyCommand.Path) "Register-1C-Comcntr.log"

function Write-Log {
    param([string]$message)
    $timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    $entry = "$timestamp `t $message"
    Write-Host $entry
    Add-Content -Path $logFile -Value $entry
}

$allVersions = @()

foreach ($basePath in $basePaths) {
    if (Test-Path $basePath) {
        $versions = Get-ChildItem -Path $basePath -Directory |
            Where-Object { $_.Name -match "^\d+\.\d+\.\d+\.\d+$" } |
            Select-Object @{Name="FullName";Expression={$_.FullName}},
                          @{Name="Version";Expression={[Version]$_.Name}},
                          @{Name="Name";Expression={$_.Name}},
                          @{Name="BasePath";Expression={$basePath}}
        $allVersions += $versions
    }
}

if ($allVersions.Count -eq 0) {
    Write-Log "❌ Не найдено ни одной установленной версии 1С!"
    exit 1
}

# Сортируем по версии, берем последнюю
$latest = $allVersions | Sort-Object Version -Descending | Select-Object -First 1
$comcntrPath = Join-Path $latest.FullName "bin\comcntr.dll"

if (-Not (Test-Path $comcntrPath)) {
    Write-Log "❌ Файл comcntr.dll не найден в $comcntrPath!"
    exit 1
}

# Получаем версию файла DLL
$dllVersion = (Get-Item $comcntrPath).VersionInfo.FileVersion

# Определяем тип платформы (x86 или x64)
$platformType = if ($latest.BasePath -like "*x86*") { "x86 (32-bit)" } else { "x64 (64-bit)" }

# Вывод и логирование информации
Write-Log "✅ Найдена последняя версия 1С: $($latest.Name)"
Write-Log "📂 Папка установки: $($latest.BasePath)"
Write-Log "💻 Тип платформы: $platformType"
Write-Log "📄 Путь к DLL: $comcntrPath"
Write-Log "ℹ️ Версия comcntr.dll: $dllVersion"

# Регистрируем DLL тихо
try {
    Start-Process "regsvr32.exe" -ArgumentList "/s `"$comcntrPath`"" -Verb RunAs -Wait
    Write-Log "✅ comcntr.dll успешно зарегистрирован."
} catch {
    Write-Log "❌ Ошибка при регистрации comcntr.dll: $_"
    exit 1
}
